Attribute VB_Name = "Module1"
' Visual Basic sample program with commmunications routines for COM1: - COM4:.
'
' "Copyright (c) Dutile, Glines and Higgins Corporation, 1994,1999"
'
Option Explicit

' Declare global string constants
Global Const ProgramTitle = "VB Sample Program"
Global Const Copyright = "Copyright (c) Dutile Glines and Higgins Corporation 1994,1999"
Global Const Version = "Verson 1.00"
Global Const Timeout = "TIMEOUT"
Global Const UpdateCaption = "&Update"
Global Const OpenCaption = "&Open"
Global Const SettingsTitle = "Port Settings"
Global Const EmptyString = ""

' Declare module protocol characters and data formats
Global Const DataFormat = "+00000.00;-00000.00"         'Use with FORMAT$
Global Const Asterisk = "*"                             'Valid Message - First Character
Global Const QuestionMark = "?"                         'Error Message - First Character
Global Const High = 1                                   'DI/DO logic 1
Global Const Low = 0                                    'DI/DO Logic 0

' Declare global error codes
Global Const Invalid_ModelNumber = 1
Global Const Port_IsOpen = 2
Global Const Port_NotOpen = 3
Global Const Port_Timeout = 4
Global Const Port_Invalid = 5
Global Const Port_RequestOpen = 6
Global Const Invalid_BaudRate = 7
Global Const Hex2Long_BadChar = 8
Global Const Hex2Long_StringToLong = 9

' Declare global module response errors
Global Const COM1_AO = 100
Global Const COM1_DI = 101
Global Const COM1_DO = 102
Global Const COM1_RD = 103
Global Const COM1_RE = 104

Global Const COM2_AO = 105
Global Const COM2_DI = 106
Global Const COM2_DO = 107
Global Const COM2_RD = 108
Global Const COM2_RE = 109

Global Const COM3_AO = 110
Global Const COM3_DI = 111
Global Const COM3_DO = 112
Global Const COM3_RD = 113
Global Const COM3_RE = 114

Global Const COM4_AO = 115
Global Const COM4_DI = 116
Global Const COM4_DO = 117
Global Const COM4_RD = 118
Global Const COM4_RE = 119

' Declare bit weights
Global Const B0 = &H1
Global Const B1 = &H2
Global Const B2 = &H4
Global Const B3 = &H8
Global Const B4 = &H10
Global Const B5 = &H20
Global Const B6 = &H40
Global Const B7 = &H80

' Declare global mouse pointer values
Global Const Pointer = 0
Global Const HourGlass = 11

' Declare global Integer variables
Global PortNumber As Integer     'Port number used by demo screen
Global Address As Integer        'Module address used by demo screen - decimal format
Global DisplayErrors As Integer  '0=DO NOT display module errors, 1=Display all errors
Global Dummy As Integer          'Used by all DO..UNTIL loops
Global Outputs As Integer        'Digital Output byte
Global StopScan As Integer       '0 = Continue scan, 1 =  Stop Scan
Global DOUpdate As Integer       '0 = Don't update "OUTPUTS", 1 = Update "OUTPUTS"
Global AOUpdate As Integer       '0 = Don't update Analog Output, 1=Update
Global GraphMx As Integer        'Demo screen graphics maximum value
Global GraphMn As Integer        'Demo screen graphics minimum value

' Declare Type defined values
Type PortInfo
    BaudRate As String
    Parity As String
    DataBits As String
    StopBits As String
    RxThreshold As Integer
    TxThreshold As Integer
    FlowControl As Integer
    ParityReplaceChar As String
    CTSTimeout As Integer
    DSRTimeout As Integer
    DTREnable As Integer
    NullDiscardValue As Integer
    RXBufferLen As Integer
    TXBufferLen As Integer
    RXTimeoutVal As Integer
    TxTimeoutVal As Integer
    PortIsOpen As Integer
    TOExpired As Integer
End Type

' Define array that will hold data from upto 4 open ports
Global Commports(4)  As PortInfo

Function Hex2Long(S As String) As Long
' Convert HEX String to LONG INTEGER
Dim Ret As Long
Dim Ptr, Value, Exponent As Integer

    ' Initialize variables
    Ret = 0
    Ptr = 0
    Value = 0
    Exponent = 0

    ' Check for proper length
    If (Len(S) > 0) And (Len(S) <= 8) Then
      For Ptr = Len(S) To 1 Step -1
       ' Loop thru all HEX characters
       Select Case Mid$(S, Ptr, 1)
        Case "0":
                Value = 0
        Case "1":
                Value = 1
        Case "2":
                Value = 2
        Case "3":
                Value = 3
        Case "4":
                Value = 4
        Case "5":
                Value = 5
        Case "6":
                Value = 6
        Case "7":
                Value = 7
        Case "8":
                Value = 8
        Case "9":
                Value = 9
        Case "A":
                Value = 10
        Case "B":
                Value = 11
        Case "C":
                Value = 12
        Case "D":
                Value = 13
        Case "E":
                Value = 14
        Case "F":
                Value = 15
       Case Else
        ' Error
        Value = 0
        PRG_Errors (Hex2Long_BadChar)
       End Select

       ' Add new value
       Ret = Ret + ((2 ^ Exponent) * Value)

       ' Increment exponent value
       Exponent = Exponent + 4

      Next Ptr     ' End FOR-NEXT
    Else
      ' Error
      PRG_Errors (Hex2Long_StringToLong)
    End If

    ' Setup return value
    Hex2Long = Ret
End Function
Sub InitPorts()
Dim X As Integer
    ' Loop thru all four ports
    For X = 1 To 4
     ' Close any open ports
     Select Case X
      Case 1:
            If MainMenu!Comm1.PortOpen = True Then
              MainMenu!Comm1.PortOpen = False
            End If
            
      ' Removed other CASE 2,3,4 statements as no other
      '  COMM controls on the project main form.
     End Select

     ' Re-initialize port settings
     InitPort (X)
    Next X
End Sub
Sub InitPort(Index As Integer)
    Commports(Index).BaudRate = "9600"            '9600 Baud
    Commports(Index).Parity = "N"                 'No Parity
    Commports(Index).DataBits = "8"               '8 Data Bits
    Commports(Index).StopBits = "1"               '1 Stop Bit
    Commports(Index).RxThreshold = 1              'Intr on 1 Char
    Commports(Index).TxThreshold = 1              'Intr on 1 Char
    Commports(Index).FlowControl = 0              'NONE
    Commports(Index).ParityReplaceChar = Chr$(255) 'Parity Error Char
    Commports(Index).CTSTimeout = 0               '0 mS
    Commports(Index).DSRTimeout = 0               '0 mS
    Commports(Index).DTREnable = True             'DTR On
    Commports(Index).NullDiscardValue = True      'Eat NULLS
    Commports(Index).RXBufferLen = 1024           '1024 Bytes
    Commports(Index).TXBufferLen = 512            '512 Bytes
    Commports(Index).RXTimeoutVal = 2000          '1000 mS
    Commports(Index).TxTimeoutVal = 100           '100 mS
    Commports(Index).TOExpired = 0                '0 = Disabled or No Timeout, 1 = Timeout
    Commports(Index).PortIsOpen = 0               'Closed
End Sub

Sub ModError1(ErrValue As Integer, Rx As String)
Dim A As String
    ' Initialize
    A = EmptyString

    ' Determine error value
    Select Case ErrValue
     Case COM1_AO:
            A = "COM1: Analog Output Failure"
     Case COM1_DI:
            A = "COM1: Digital Input Failure"
     Case COM1_DO:
            A = "COM1: Digital Output Failure"
     Case COM1_RD:
            A = "COM1: Read Data Failure"
     Case COM1_RE:
            A = "COM1: Read Events Failure"
    End Select

    ' Display error message
    If A <> EmptyString Then
      MsgBox Rx, 48, A
    End If
End Sub
Sub SetPortValues(Index As Integer)
    Select Case Index
     Case 1:
            MainMenu!Comm1.RThreshold = Commports(Index).RxThreshold
            MainMenu!Comm1.SThreshold = Commports(Index).TxThreshold
            MainMenu!Comm1.Handshaking = Commports(Index).FlowControl
            MainMenu!Comm1.ParityReplace = Commports(Index).ParityReplaceChar
            MainMenu!Comm1.CTSTimeout = Commports(Index).CTSTimeout
            MainMenu!Comm1.DSRTimeout = Commports(Index).DSRTimeout
            MainMenu!Comm1.DTREnable = Commports(Index).DTREnable
            MainMenu!Comm1.NullDiscard = Commports(Index).NullDiscardValue
            MainMenu!Comm1.InBufferSize = Commports(Index).RXBufferLen
            MainMenu!Comm1.OutBufferSize = Commports(Index).TXBufferLen
    
     ' Removed other case selections 2,3,4 as no other COMM controls
     '  on main menu form
    End Select
End Sub
Sub OpenPort(Index As Integer)
    ' Setup error handler and open the hardware port
    'On Error GoTo ComOpenError
    MainMenu.MousePointer = 11
    Select Case Index
     Case 1:
            ' Is port already Open
            If Commports(Index).PortIsOpen = 1 Then
              MainMenu!Comm1.PortOpen = False
            End If

            ' Setup values
            SetPortValues (1)
            MainMenu!Comm1.InBufferSize = Commports(1).RXBufferLen
            MainMenu!Comm1.OutBufferSize = Commports(1).TXBufferLen
            MainMenu!Comm1.Settings = Commports(1).BaudRate + "," + Commports(1).Parity + "," + Commports(1).DataBits + "," + Commports(1).StopBits
            MainMenu!Comm1.CommPort = 1
            MainMenu!Comm1.PortOpen = True
            Commports(Index).TOExpired = 0
            Commports(Index).PortIsOpen = 1
            
     ' Removed other CASE selections 2,3,4 as no other
     '  COMM controls on main form

    End Select
    MainMenu.MousePointer = 0
    Exit Sub

ComOpenError:
    ' Display proper error message
    MainMenu.MousePointer = 0
    PRG_Errors (68)

    ' Reset the port
    InitPort (Index)
    Exit Sub
End Sub
Sub PRG_Errors(Index As Integer)
Dim A As String * 55
    ' Initialize variables
    A = ""

    ' Determine error value
    Select Case Index
     Case Port_IsOpen:
            A = "Communications port is already open!"
     
     Case Port_NotOpen:
            A = "Selected communications port is not open!"

     Case Port_Timeout:
            A = "A communications timeout error has occurred"

     Case Port_Invalid:
            A = "Entered communications port number is invalid"

     Case Port_RequestOpen:
            A = "A communications port must be opened before proceeding"

     Case Invalid_BaudRate:
            A = "Invalid baud rate value in SetBaud()"

     Case Invalid_ModelNumber:
            A = "Please enter a valid model number"

     Case Hex2Long_StringToLong:
            A = "Long integer string value to long"

     Case Hex2Long_BadChar:
            A = "Invalid hexadecimal string character"

     Case 68:
            A = "Error Opening selected communications port!"

    End Select

    ' Display the error message and PAUSE
    If Index > 0 Then
      MsgBox A, 48, "Error Message"
    End If
End Sub
Sub ClosePort(Index As Integer)
    ' Open the desired port
    If (MainMenu!Comm1.PortOpen = True) Then
      InitPort (1)
      MainMenu!Comm1.PortOpen = False
      SetPortValues (1)
    End If
End Sub
Sub TX1(S As String)
    ' Check for OPEN COM1: port
    If Commports(1).PortIsOpen = 1 Then
      ' Transmit command
      MainMenu!Comm1.Output = S
    Else
      ' Port not OPEN
      PRG_Errors (Port_NotOpen)
    End If
End Sub
Function RX1() As String
Dim A, B As String
Dim Start As Integer
    '
    ' Read response message from port
    '
    ' Return value DOES NOT contain <CR> on end
    '
    A = ""
    Start = 0

    If Commports(1).PortIsOpen = 1 Then
      MainMenu!Comm1.InputLen = 1
      MainMenu!Timer1.Interval = Commports(1).RXTimeoutVal
      MainMenu!Timer1.Enabled = True

      Do
        ' Allow other windows events
        Dummy = DoEvents()

        ' Get characters from comm port
        If MainMenu!Comm1.InBufferCount > 0 Then
          ' Read character
          B = Chr$(Asc(MainMenu!Comm1.Input) And &H7F)

          ' Check for valid start of message
          If (B = Asterisk) Or (B = QuestionMark) Then
            Start = 1
            A = B
           Else
            ' Build response message
            If Start = 1 Then A = A + B
          End If
        End If
      Loop Until (Right$(A, 1) = Chr$(13)) Or (Commports(1).TOExpired = 1)

      ' Disable COM1: timeout interval timer (0)
      MainMenu!Timer1.Interval = 0
      MainMenu!Timer1.Enabled = False

      ' Strip <CR> and Set return value
      If Commports(1).TOExpired = 1 Then
        Commports(1).TOExpired = 0
        RX1 = Timeout
      Else
        RX1 = Left$(A, Len(A) - 1)
      End If
    Else
     ' Port Not Open
     PRG_Errors (Port_NotOpen)
     RX1 = Timeout
    End If
End Function
Sub AO_CMD(Address, ReportError As Integer, AOValue As Double)
'
' Address received as integer value
' AOValue equals REAL value to be output to module
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Output numeric string value using AO command
    On Error GoTo AOError1
    Rx = Format$(AOValue, DataFormat)
    TX1 ("$" + Chr$(Address) + "AO" + Rx + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Module or Communications Error
      If ReportError <> 0 Then
        ' Display error message
        ModError1 COM1_AO, Rx
      End If
    End If
    Exit Sub

AOError1:
    ' Display Analog Output value error
    MsgBox "Bad value received by COM1: Analog output routine", 48
    Exit Sub
End Sub
Function DI_CMD(Address, ByteNum, ReportError As Integer) As Long
'
' Address received as integer value
' ByteNum value must be between 1..8 !
' ReportError <> 0 will STOP routine and display error using MSGBOX
' Return value is BYTE value or FULL 8 bits
'
Dim Rx As String
    ' Return numeric string value from DI command
    TX1 ("$" + Chr$(Address) + "DI" + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
      Rx = Mid$(Rx, ByteNum * 2, 2)
      DI_CMD = Hex2Long(Rx)
    Else
      ' Module or Communications Error
      ' Setup default value
      DI_CMD = 0

      If ReportError <> 0 Then
        ' Display error message
        ModError1 COM1_DI, Rx
      End If
    End If
End Function
Sub DO_CMD(Address, OutputValue, ReportError As Integer)
'
' Address received as integer value
' OutputValue is converted to HEX and sent with DO command
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Format output value
    Rx = Hex$(OutputValue)
    Do Until Len(Rx) > 4
      Rx = "0" + Rx
    Loop

    ' Output DO command
    TX1 ("$" + Chr$(Address) + "DO" + Right$(Rx, 2) + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Error occured
      If ReportError <> 0 Then
        ' Module Error
        ModError1 COM1_DO, Rx
      End If
    End If
End Sub
Function RD_CMD(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RD command
    TX1 ("$" + Chr$(Address) + "RD" + Chr$(13))
    Rx = RX1()
    
    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError1 COM1_RD, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 9)
    End If

    ' Set return
    RD_CMD = Rx
End Function
Function RE_CMD(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RE command
    TX1 ("$" + Chr$(Address) + "RE" + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError1 COM1_RE, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 7)
    End If

    ' Set return
    RE_CMD = Rx
End Function
