VERSION 5.00
Begin VB.Form AODemo 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C000&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Any analog output module"
   ClientHeight    =   4785
   ClientLeft      =   1425
   ClientTop       =   960
   ClientWidth     =   4575
   ClipControls    =   0   'False
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4785
   ScaleWidth      =   4575
   Begin VB.ComboBox Combo1 
      Appearance      =   0  'Flat
      Height          =   315
      Left            =   2160
      Style           =   2  'Dropdown List
      TabIndex        =   14
      Top             =   2350
      Width           =   1455
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "DIGITAL INPUTS (Status)"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   1020
      Left            =   840
      TabIndex        =   9
      Top             =   2880
      Width           =   3015
      Begin VB.Image Image6 
         Appearance      =   0  'Flat
         Height          =   480
         Left            =   240
         Picture         =   "COMMAO.frx":0000
         Top             =   240
         Width           =   480
      End
      Begin VB.Image Image5 
         Appearance      =   0  'Flat
         Height          =   480
         Left            =   240
         Picture         =   "COMMAO.frx":0282
         Top             =   240
         Width           =   480
      End
      Begin VB.Image Image4 
         Appearance      =   0  'Flat
         Height          =   480
         Left            =   1320
         Picture         =   "COMMAO.frx":0504
         Top             =   240
         Width           =   480
      End
      Begin VB.Image Image3 
         Appearance      =   0  'Flat
         Height          =   480
         Left            =   1320
         Picture         =   "COMMAO.frx":0786
         Top             =   240
         Width           =   480
      End
      Begin VB.Image Image2 
         Appearance      =   0  'Flat
         Height          =   480
         Left            =   2280
         Picture         =   "COMMAO.frx":0A08
         Top             =   240
         Width           =   480
      End
      Begin VB.Image Image1 
         Appearance      =   0  'Flat
         Height          =   480
         Left            =   2280
         Picture         =   "COMMAO.frx":0C8A
         Top             =   240
         Width           =   480
      End
      Begin VB.Label Label3 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "DI2"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   240
         Left            =   300
         TabIndex        =   12
         Top             =   720
         Width           =   360
      End
      Begin VB.Label Label2 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "DI1"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   240
         Left            =   1320
         TabIndex        =   11
         Top             =   720
         Width           =   360
      End
      Begin VB.Label Label1 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "DI0"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   240
         Left            =   2400
         TabIndex        =   10
         Top             =   720
         Width           =   360
      End
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   372
      LargeChange     =   1000
      Left            =   1080
      Max             =   10000
      SmallChange     =   100
      TabIndex        =   5
      Top             =   1440
      Width           =   2532
   End
   Begin VB.TextBox Text1 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   19.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FFFF&
      Height          =   615
      Left            =   1080
      MaxLength       =   9
      TabIndex        =   4
      Text            =   "+00000.00"
      Top             =   600
      Width           =   2535
   End
   Begin VB.CommandButton AOCancel 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Cancel"
      Height          =   372
      Left            =   3480
      TabIndex        =   3
      Top             =   4200
      Width           =   852
   End
   Begin VB.CommandButton AOSetup 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "S&etup"
      Height          =   372
      Left            =   2400
      TabIndex        =   2
      Top             =   4200
      Width           =   852
   End
   Begin VB.CommandButton AOStop 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Stop"
      Height          =   372
      Left            =   1320
      TabIndex        =   1
      Top             =   4200
      Width           =   852
   End
   Begin VB.CommandButton AORun 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Run"
      Height          =   372
      Left            =   240
      TabIndex        =   0
      Top             =   4200
      Width           =   852
   End
   Begin VB.Label Label4 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "COM PORT"
      ForeColor       =   &H80000008&
      Height          =   195
      Left            =   1080
      TabIndex        =   13
      Top             =   2425
      Width           =   990
   End
   Begin VB.Label lblMaximum 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "100"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   240
      Left            =   3240
      TabIndex        =   8
      Top             =   1920
      Width           =   375
   End
   Begin VB.Label lblMinimum 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   240
      Left            =   1080
      TabIndex        =   7
      Top             =   1920
      Width           =   105
   End
   Begin VB.Label lblAOData 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "ANALOG OUTPUT"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   240
      Left            =   1080
      TabIndex        =   6
      Top             =   300
      Width           =   1935
   End
End
Attribute VB_Name = "AODemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' "Copyright (c) 1994,98 Dutile, Glines and Higgins Corporation"

Const FRMCaption = "Analog Output Demonstration"

Private Sub AOCancel_Click()
    ' Hide the analog output demonstration form
    AODemo.Hide
End Sub

Private Sub AORun_Click()
    ' Check for valid port
    If Val(Mid$(Combo1.Text, 4, 1)) = 0 Then
      ' Error message - Invalid port selected
      MsgBox "Select valid port value [1..4]", 48
      
      ' Exit sub
      Exit Sub
    End If

    ' Disable other keys during scan
    AORun.Enabled = False
    AOSetup.Enabled = False
    AOCancel.Enabled = False
    AOStop.Enabled = True
    AOStop.Default = True
    Combo1.Enabled = False
    Frame1.Enabled = True

    ' Begin data logging
    Do Until (StopScan = 1)
     ' Output commands to selected port
     Select Case Val(Mid$(Combo1.Text, 4, 1))
      Case 1: ' SERIAL COMMUNICATIONS PORT COM1:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO1 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI1(Address, 2, DisplayErrors))

      Case 2: ' SERIAL COMMUNICATIONS PORT COM2:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO2 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI2(Address, 2, DisplayErrors))

      Case 3: ' SERIAL COMMUNICATIONS PORT COM3:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO3 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI3(Address, 2, DisplayErrors))

      Case 4: ' SERIAL COMMUNICATIONS PORT COM4:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO4 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI4(Address, 2, DisplayErrors))
      Case Else
       ' Invalid port selected
       MsgBox "Select valid port value [1..4]", 48
     End Select

     ' Allow more events
     Dummy = DoEvents()
    Loop

    ' Disable scanning
    StopScan = 0
End Sub

Private Sub AOSetup_Click()
    ' Show setup form
    PRGSetup.Show
End Sub

Private Sub AOStop_Click()
    ' Enable other keys after scan
    AORun.Enabled = True
    AORun.Default = True
    AOSetup.Enabled = True
    AOCancel.Enabled = True
    AOStop.Enabled = False
    Combo1.Enabled = True
    Frame1.Enabled = False

    ' Set flag to stop scanning
    StopScan = 1
End Sub

Private Sub Form_Activate()
    ' Update ports box
    LoadPorts Combo1
End Sub

Private Sub Form_Load()
    ' Initialize horizontal scroll bar and text box
    HScroll1.Value = HScroll1.Min
    Text1.Text = Format$((HScroll1.Value / 100), DataFormat)

    ' Initialize digital input LED's
    UpdateLEDs (&HFF)

    ' Initialize caption
    AODemo.Caption = FRMCaption
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    ' Prompt if still scanning
    If AOStop.Enabled = True Then
      ' Display message
      MsgBox "Must stop demo first", 48

      ' Cancel the unload function
      Cancel = 1
    End If
End Sub

Private Sub HScroll1_Change()
    ' Set Analog Output flag
    Text1.Text = Format$((HScroll1.Value / 100), DataFormat)
    AOUpdate = 1
End Sub

Private Sub Text1_Change()
Dim Old As Long
    ' Update horizontal scroll bar
    On Error GoTo BadValue
    Old = HScroll1.Value
    HScroll1.Value = Val(Text1.Text) * 100
    AOUpdate = 1
    Exit Sub

BadValue:
    On Error GoTo 0
    HScroll1.Value = Old
    Text1.Text = HScroll1.Value / 100
    AOUpdate = 0
    Exit Sub
End Sub

Private Sub UpdateLEDs(Status As Long)
    ' Update the digital input LED's
    ' Check Bit #0
    If (Status And B0) = Low Then
      Image1.Enabled = True
      Image1.Visible = True
      Image2.Enabled = False
      Image2.Visible = False
    Else
      Image1.Enabled = False
      Image1.Visible = False
      Image2.Enabled = True
      Image2.Visible = True
    End If

    ' Check Bit #1
    If (Status And B1) = Low Then
      Image3.Enabled = True
      Image3.Visible = True
      Image4.Enabled = False
      Image4.Visible = False
    Else
      Image3.Enabled = False
      Image3.Visible = False
      Image4.Enabled = True
      Image4.Visible = True
    End If

    ' Check Bit #2
    If (Status And B2) = Low Then
      Image5.Enabled = True
      Image5.Visible = True
      Image6.Enabled = False
      Image6.Visible = False
    Else
      Image5.Enabled = False
      Image5.Visible = False
      Image6.Enabled = True
      Image6.Visible = True
    End If
End Sub

