Attribute VB_Name = "COMM1"
' Visual Basic sample program with commmunications routines for COM1: - COM4:.
'
' "Copyright (c) 1994,98 Dutile, Glines and Higgins Corporation (DGH)"
'
Option Explicit

' Declare global string constants
Global Const ProgramTitle = "VB Sample Program"
Global Const Copyright = "Copyright (c) DGH Corporation 1994,1998"
Global Const Version = "Verson 1.00"
Global Const Timeout = "TIMEOUT"
Global Const UpdateCaption = "&Update"
Global Const OpenCaption = "&Open"
Global Const SettingsTitle = "Port Settings"
Global Const EmptyString = ""

' Declare module protocol characters and data formats
Global Const DataFormat = "+00000.00;-00000.00"         'Use with FORMAT$
Global Const Asterisk = "*"                             'Valid Message - First Character
Global Const QuestionMark = "?"                         'Error Message - First Character
Global Const High = 1                                   'DI/DO logic 1
Global Const Low = 0                                    'DI/DO Logic 0

' Declare global error codes
Global Const Invalid_ModelNumber = 1
Global Const Port_IsOpen = 2
Global Const Port_NotOpen = 3
Global Const Port_Timeout = 4
Global Const Port_Invalid = 5
Global Const Port_RequestOpen = 6
Global Const Invalid_BaudRate = 7
Global Const Hex2Long_BadChar = 8
Global Const Hex2Long_StringToLong = 9

' Declare global module response errors
Global Const COM1_AO = 100
Global Const COM1_DI = 101
Global Const COM1_DO = 102
Global Const COM1_RD = 103
Global Const COM1_RE = 104

Global Const COM2_AO = 105
Global Const COM2_DI = 106
Global Const COM2_DO = 107
Global Const COM2_RD = 108
Global Const COM2_RE = 109

Global Const COM3_AO = 110
Global Const COM3_DI = 111
Global Const COM3_DO = 112
Global Const COM3_RD = 113
Global Const COM3_RE = 114

Global Const COM4_AO = 115
Global Const COM4_DI = 116
Global Const COM4_DO = 117
Global Const COM4_RD = 118
Global Const COM4_RE = 119

' Declare bit weights
Global Const B0 = &H1
Global Const B1 = &H2
Global Const B2 = &H4
Global Const B3 = &H8
Global Const B4 = &H10
Global Const B5 = &H20
Global Const B6 = &H40
Global Const B7 = &H80

' Declare global mouse pointer values
Global Const Pointer = 0
Global Const HourGlass = 11

' Declare global Integer variables
Global PortNumber As Integer     'Port number used by demo screen
Global Address As Integer        'Module address used by demo screen - decimal format
Global DisplayErrors As Integer  '0=DO NOT display module errors, 1=Display all errors
Global Dummy As Integer          'Used by all DO..UNTIL loops
Global Outputs As Integer        'Digital Output byte
Global StopScan As Integer       '0 = Continue scan, 1 =  Stop Scan
Global DOUpdate As Integer       '0 = Don't update "OUTPUTS", 1 = Update "OUTPUTS"
Global AOUpdate As Integer       '0 = Don't update Analog Output, 1=Update
Global GraphMx As Integer        'Demo screen graphics maximum value
Global GraphMn As Integer        'Demo screen graphics minimum value

' Declare Type defined values
Type PortInfo
    BaudRate As String
    Parity As String
    DataBits As String
    StopBits As String
    RxThreshold As Integer
    TxThreshold As Integer
    FlowControl As Integer
    ParityReplaceChar As String
    CTSTimeout As Integer
    DSRTimeout As Integer
    DTREnable As Integer
    NullDiscardValue As Integer
    RXBufferLen As Integer
    TXBufferLen As Integer
    RXTimeoutVal As Integer
    TxTimeoutVal As Integer
    PortIsOpen As Integer
    TOExpired As Integer
End Type

' Define array that will hold data from upto 4 open ports
Global Commports(4)  As PortInfo

Sub AO1(Address, ReportError As Integer, AOValue As Double)
'
' Address received as integer value
' AOValue equals REAL value to be output to module
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Output numeric string value using AO command
    On Error GoTo AOError1
    Rx = Format$(AOValue, DataFormat)
    TX1 ("$" + Chr$(Address) + "AO" + Rx + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Module or Communications Error
      If ReportError <> 0 Then
        ' Display error message
        ModError1 COM1_AO, Rx
      End If
    End If
    Exit Sub

AOError1:
    ' Display Analog Output value error
    MsgBox "Bad value received by COM1: Analog output routine", 48
    Exit Sub
End Sub

Sub AO2(Address, ReportError As Integer, AOValue As Double)
'
' Address received as integer value
' AOValue equals REAL value to be output to module
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Output numeric string value using AO command
    On Error GoTo AOError2
    Rx = Format$(AOValue, DataFormat)
    TX2 ("$" + Chr$(Address) + "AO" + Rx + Chr$(13))
    Rx = RX2()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Module or Communications Error
      If ReportError <> 0 Then
        ' Display error message
        ModError2 COM2_AO, Rx
      End If
    End If
    Exit Sub

AOError2:
    ' Display Analog Output value error
    MsgBox "Bad value received by COM2: Analog output routine", 48
    Exit Sub
End Sub

Sub AO3(Address, ReportError As Integer, AOValue As Double)
'
' Address received as integer value
' AOValue equals REAL value to be output to module
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Output numeric string value using AO command
    On Error GoTo AOError3
    Rx = Format$(AOValue, DataFormat)
    TX3 ("$" + Chr$(Address) + "AO" + Rx + Chr$(13))
    Rx = RX3()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Module or Communications Error
      If ReportError <> 0 Then
        ' Display error message
        ModError3 COM3_AO, Rx
      End If
    End If
    Exit Sub

AOError3:
    ' Display Analog Output value error
    MsgBox "Bad value received by COM3: Analog output routine", 48
    Exit Sub
End Sub

Sub AO4(Address, ReportError As Integer, AOValue As Double)
'
' Address received as integer value
' AOValue equals REAL value to be output to module
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Output numeric string value using AO command
    On Error GoTo AOError4
    Rx = Format$(AOValue, DataFormat)
    TX4 ("$" + Chr$(Address) + "AO" + Rx + Chr$(13))
    Rx = RX4()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Module or Communications Error
      If ReportError <> 0 Then
        ' Display error message
        ModError4 COM4_AO, Rx
      End If
    End If
    Exit Sub

AOError4:
    ' Display Analog Output value error
    MsgBox "Bad value received by COM4: Analog output routine", 48
    Exit Sub
End Sub

Sub ClosePort(Index As Integer)
    ' Open the desired port
    If (Settings!Check3D1.Value = True) And (MainMenu!Comm1.PortOpen = True) Then
      InitPort (1)
      MainMenu!Comm1.PortOpen = False
      SetPortValues (1)
      Settings!Check3D1.Value = False
    End If

    If (Settings!Check3D2.Value = True) And (MainMenu!Comm2.PortOpen = True) Then
      InitPort (2)
      MainMenu!Comm2.PortOpen = False
      SetPortValues (2)
      Settings!Check3D2.Value = False
    End If

    If (Settings!Check3D3.Value = True) And (MainMenu!Comm3.PortOpen = True) Then
      InitPort (3)
      MainMenu!Comm3.PortOpen = False
      SetPortValues (3)
      Settings!Check3D3.Value = False
    End If

    If (Settings!Check3D4.Value = True) And (MainMenu!Comm4.PortOpen = True) Then
      InitPort (4)
      MainMenu!Comm4.PortOpen = False
      SetPortValues (4)
      Settings!Check3D4.Value = False
    End If
End Sub

Function DI1(Address, ByteNum, ReportError As Integer) As Long
'
' Address received as integer value
' ByteNum value must be between 1..8 !
' ReportError <> 0 will STOP routine and display error using MSGBOX
' Return value is BYTE value or FULL 8 bits
'
Dim Rx As String
    ' Return numeric string value from DI command
    TX1 ("$" + Chr$(Address) + "DI" + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
      Rx = Mid$(Rx, ByteNum * 2, 2)
      DI1 = Hex2Long(Rx)
    Else
      ' Module or Communications Error
      ' Setup default value
      DI1 = 0

      If ReportError <> 0 Then
        ' Display error message
        ModError1 COM1_DI, Rx
      End If
    End If
End Function

Function DI2(Address, ByteNum, ReportError As Integer) As Long
'
' Address received as integer value
' ByteNum value must be between 1..8 !
' ReportError <> 0 will STOP routine and display error using MSGBOX
' Return value is BYTE value or FULL 8 bits
'
Dim Rx As String
    ' Return numeric string value from DI command
    TX2 ("$" + Chr$(Address) + "DI" + Chr$(13))
    Rx = RX2()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
      Rx = Mid$(Rx, ByteNum * 2, 2)
      DI2 = Hex2Long(Rx)
    Else
      ' Module or Communications Error
      ' Setup default value
      DI2 = 0

      If ReportError <> 0 Then
        ' Display error message
        ModError2 COM2_DI, Rx
      End If
    End If
End Function

Function DI3(Address, ByteNum, ReportError As Integer) As Long
'
' Address received as integer value
' ByteNum value must be between 1..8 !
' ReportError <> 0 will STOP routine and display error using MSGBOX
' Return value is BYTE value or FULL 8 bits
'
Dim Rx As String
    ' Return numeric string value from DI command
    TX3 ("$" + Chr$(Address) + "DI" + Chr$(13))
    Rx = RX3()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
      Rx = Mid$(Rx, ByteNum * 2, 2)
      DI3 = Hex2Long(Rx)
    Else
      ' Module or Communications Error
      ' Setup default value
      DI3 = 0

      If ReportError <> 0 Then
        ' Display error message
        ModError3 COM3_DI, Rx
      End If
    End If
End Function

Function DI4(Address, ByteNum, ReportError As Integer) As Long
'
' Address received as integer value
' ByteNum value must be between 1..8 !
' ReportError <> 0 will STOP routine and display error using MSGBOX
' Return value is BYTE value or FULL 8 bits
'
Dim Rx As String
    ' Return numeric string value from DI command
    TX4 ("$" + Chr$(Address) + "DI" + Chr$(13))
    Rx = RX4()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
      Rx = Mid$(Rx, ByteNum * 2, 2)
      DI4 = Hex2Long(Rx)
    Else
      ' Module or Communications Error
      ' Setup default value
      DI4 = 0

      If ReportError <> 0 Then
        ' Display error message
        ModError4 COM4_DI, Rx
      End If
    End If
End Function

Sub DisplayCOM1()
    ' Display the communications port settings for COM1
    Values2Screen (1)

    ' Setup screen title
    Settings.Caption = "COM1: " + SettingsTitle

    ' Activate proper port value
    Settings!Check3D1.Enabled = True
    Settings!Check3D2.Enabled = False
    Settings!Check3D3.Enabled = False
    Settings!Check3D4.Enabled = False

    ' Modify SETTINGS buttons if PORT = OPEN
    If MainMenu!Comm1.PortOpen = True Then
      Settings!Open.Caption = UpdateCaption
    Else
      Settings!Open.Caption = OpenCaption
    End If

    ' Display screen
    Settings.Show
End Sub

Sub DisplayCOM2()
    ' Display the communications port settings for COM2
    Values2Screen (2)

    ' Setup screen title
    Settings.Caption = "COM2: " + SettingsTitle

    ' Activate proper port value
    Settings!Check3D1.Enabled = False
    Settings!Check3D2.Enabled = True
    Settings!Check3D3.Enabled = False
    Settings!Check3D4.Enabled = False

    ' Modify SETTINGS buttons if PORT = OPEN
    If MainMenu!Comm2.PortOpen = True Then
      Settings!Open.Caption = UpdateCaption
    Else
      Settings!Open.Caption = OpenCaption
    End If

    ' Display screen
    Settings.Show
End Sub

Sub DisplayCOM3()
    ' Display the communications port settings for COM3
    Values2Screen (3)

    ' Setup screen title
    Settings.Caption = "COM3: " + SettingsTitle

    ' Activate proper port value
    Settings!Check3D1.Enabled = False
    Settings!Check3D2.Enabled = False
    Settings!Check3D3.Enabled = True
    Settings!Check3D4.Enabled = False

    ' Modify SETTINGS buttons if PORT = OPEN
    If MainMenu!Comm3.PortOpen = True Then
      Settings!Open.Caption = UpdateCaption
    Else
      Settings!Open.Caption = OpenCaption
    End If

    ' Display screen
    Settings.Show
End Sub

Sub DisplayCOM4()
    ' Display the communications port settings for COM4
    Values2Screen (4)

    ' Setup screen title
    Settings.Caption = "COM4: " + SettingsTitle

    ' Activate proper port value
    Settings!Check3D1.Enabled = False
    Settings!Check3D2.Enabled = False
    Settings!Check3D3.Enabled = False
    Settings!Check3D4.Enabled = True

    ' Modify SETTINGS buttons if PORT = OPEN
    If MainMenu!Comm4.PortOpen = True Then
      Settings!Open.Caption = UpdateCaption
    Else
      Settings!Open.Caption = OpenCaption
    End If

    ' Display screen
    Settings.Show
End Sub

Sub DO1(Address, OutputValue, ReportError As Integer)
'
' Address received as integer value
' OutputValue is converted to HEX and sent with DO command
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Format output value
    Rx = Hex$(OutputValue)
    Do Until Len(Rx) > 4
      Rx = "0" + Rx
    Loop

    ' Output DO command
    TX1 ("$" + Chr$(Address) + "DO" + Right$(Rx, 2) + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Error occured
      If ReportError <> 0 Then
        ' Module Error
        ModError1 COM1_DO, Rx
      End If
    End If
End Sub

Sub DO2(Address, OutputValue, ReportError As Integer)
'
' Address received as integer value
' OutputValue is converted to HEX and sent with DO command
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Format output value
    Rx = Hex$(OutputValue)
    Do Until Len(Rx) > 4
      Rx = "0" + Rx
    Loop

    ' Output DO command
    TX2 ("$" + Chr$(Address) + "DO" + Right$(Rx, 2) + Chr$(13))
    Rx = RX2()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Error occured
      If ReportError <> 0 Then
        ' Module Error
        ModError2 COM2_DO, Rx
      End If
    End If
End Sub

Sub DO3(Address, OutputValue, ReportError As Integer)
'
' Address received as integer value
' OutputValue is converted to HEX and sent with DO command
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Format output value
    Rx = Hex$(OutputValue)
    Do Until Len(Rx) > 4
      Rx = "0" + Rx
    Loop

    ' Output DO command
    TX3 ("$" + Chr$(Address) + "DO" + Right$(Rx, 2) + Chr$(13))
    Rx = RX3()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Error occured
      If ReportError <> 0 Then
        ' Module Error
        ModError3 COM3_DO, Rx
      End If
    End If
End Sub

Sub DO4(Address, OutputValue, ReportError As Integer)
'
' Address received as integer value
' OutputValue is converted to HEX and sent with DO command
' ReportError <> 0 will STOP routine and display error using MSGBOX
'
Dim Rx As String
    ' Format output value
    Rx = Hex$(OutputValue)
    Do Until Len(Rx) > 4
      Rx = "0" + Rx
    Loop

    ' Output DO command
    TX4 ("$" + Chr$(Address) + "DO" + Right$(Rx, 2) + Chr$(13))
    Rx = RX4()

    ' Validate response
    If Left$(Rx, 1) = Asterisk Then
      ' Good response - EXIT ROUTINE
    Else
      ' Error occured
      If ReportError <> 0 Then
        ' Module Error
        ModError4 COM4_DO, Rx
      End If
    End If
End Sub

Function Hex2Long(S As String) As Long
' Convert HEX String to LONG INTEGER
Dim Ret As Long
Dim Ptr, Value, Exponent As Integer

    ' Initialize variables
    Ret = 0
    Ptr = 0
    Value = 0
    Exponent = 0

    ' Check for proper length
    If (Len(S) > 0) And (Len(S) <= 8) Then
      For Ptr = Len(S) To 1 Step -1
       ' Loop thru all HEX characters
       Select Case Mid$(S, Ptr, 1)
        Case "0":
                Value = 0
        Case "1":
                Value = 1
        Case "2":
                Value = 2
        Case "3":
                Value = 3
        Case "4":
                Value = 4
        Case "5":
                Value = 5
        Case "6":
                Value = 6
        Case "7":
                Value = 7
        Case "8":
                Value = 8
        Case "9":
                Value = 9
        Case "A":
                Value = 10
        Case "B":
                Value = 11
        Case "C":
                Value = 12
        Case "D":
                Value = 13
        Case "E":
                Value = 14
        Case "F":
                Value = 15
       Case Else
        ' Error
        Value = 0
        PRG_Errors (Hex2Long_BadChar)
       End Select

       ' Add new value
       Ret = Ret + ((2 ^ Exponent) * Value)

       ' Increment exponent value
       Exponent = Exponent + 4

      Next Ptr     ' End FOR-NEXT
    Else
      ' Error
      PRG_Errors (Hex2Long_StringToLong)
    End If

    ' Setup return value
    Hex2Long = Ret
End Function

Sub Initialize()
    ' Initialize the program variables
    MainMenu.MousePointer = 11

    ' Set the program default ADDRESS and Model Number
    PortNumber = 1
    Address = 49
    StopScan = 0
    DOUpdate = 1
    AOUpdate = 1
    DisplayErrors = 1
    
    ' Initialize ABOUT form
    About!Label1.Caption = ProgramTitle
    About!Label2.Caption = Copyright
    About!Label3.Caption = Version

    ' Initialize AI DEMO screen
    GraphMx = 100
    GraphMn = 0
    AIDemo!StopButton.Enabled = False
    AIDemo!RunButton.Default = True
    AODemo!AOStop.Enabled = False
    AODemo!AORun.Default = True

    ' Initialize digital I/O bytes
    Outputs = 0

    ' Disable the correct menu selections
    MainMenu.Caption = ProgramTitle

    ' Initialize communications ports
    InitPorts
    MainMenu.MousePointer = 0
End Sub

Sub InitPort(Index As Integer)
    Commports(Index).BaudRate = "300"             '300 Baud
    Commports(Index).Parity = "N"                 'No Parity
    Commports(Index).DataBits = "8"               '8 Data Bits
    Commports(Index).StopBits = "1"               '1 Stop Bit
    Commports(Index).RxThreshold = 1              'Intr on 1 Char
    Commports(Index).TxThreshold = 1              'Intr on 1 Char
    Commports(Index).FlowControl = 0              'NONE
    Commports(Index).ParityReplaceChar = Chr$(255) 'Parity Error Char
    Commports(Index).CTSTimeout = 0               '0 mS
    Commports(Index).DSRTimeout = 0               '0 mS
    Commports(Index).DTREnable = True             'DTR On
    Commports(Index).NullDiscardValue = True      'Eat NULLS
    Commports(Index).RXBufferLen = 1024           '1024 Bytes
    Commports(Index).TXBufferLen = 512            '512 Bytes
    Commports(Index).RXTimeoutVal = 2000          '1000 mS
    Commports(Index).TxTimeoutVal = 100           '100 mS
    Commports(Index).TOExpired = 0                '0 = Disabled or No Timeout, 1 = Timeout
    Commports(Index).PortIsOpen = 0               'Closed
End Sub

Sub InitPorts()
Dim X As Integer
    ' Loop thru all four ports
    For X = 1 To 4
     ' Close any open ports
     Select Case X
     Case 1:
            If MainMenu!Comm1.PortOpen = True Then
              MainMenu!Comm1.PortOpen = False
            End If
     Case 2:
            If MainMenu!Comm2.PortOpen = True Then
              MainMenu!Comm2.PortOpen = False
            End If
     Case 3:
            If MainMenu!Comm3.PortOpen = True Then
              MainMenu!Comm3.PortOpen = False
            End If
     Case 4:
            If MainMenu!Comm4.PortOpen = True Then
              MainMenu!Comm4.PortOpen = False
            End If
     End Select

     ' Re-initialize port settings
     InitPort (X)
    Next X
End Sub

Sub LoadPorts(Ctrl As ComboBox)
Dim I%
    ' Load communications port list box
    Ctrl.Clear
    For I% = 1 To 4
      ' Check for open ports
      If Commports(I%).PortIsOpen = 1 Then
        ' Add port OPEN info to combo box
        Ctrl.AddItem "COM" + Trim$(Str$(I%)) + ":"
      End If
    Next I%

    ' Reset the list index
    If Ctrl.ListCount = 0 Then
      ' Add empty message
      Ctrl.AddItem "Setup Port"
    End If

    ' Reset
    Ctrl.ListIndex = 0
End Sub

Sub ModError1(ErrValue As Integer, Rx As String)
Dim A As String
    ' Initialize
    A = EmptyString

    ' Determine error value
    Select Case ErrValue
     Case COM1_AO:
            A = "COM1: Analog Output Failure"
     Case COM1_DI:
            A = "COM1: Digital Input Failure"
     Case COM1_DO:
            A = "COM1: Digital Output Failure"
     Case COM1_RD:
            A = "COM1: Read Data Failure"
     Case COM1_RE:
            A = "COM1: Read Events Failure"
    End Select

    ' Display error message
    If A <> EmptyString Then
      MsgBox Rx, 48, A
    End If
End Sub

Sub ModError2(ErrValue As Integer, Rx As String)
Dim A As String
    ' Initialize
    A = EmptyString

    ' Determine error
    Select Case ErrValue
     Case COM2_AO:
            A = "COM2: Analog Output Failure"
     Case COM2_DI:
            A = "COM2: Digital Input Failure"
     Case COM2_DO:
            A = "COM2: Digital Output Failure"
     Case COM2_RD:
            A = "COM2: Read Data Failure"
     Case COM2_RE:
            A = "COM2: Read Events Failure"
    End Select

    ' Display error message
    If A <> EmptyString Then
      MsgBox Rx, 48, A
    End If
End Sub

Sub ModError3(ErrValue As Integer, Rx As String)
Dim A As String
    ' Initialize
    A = EmptyString

    ' Determine error
    Select Case ErrValue
     Case COM3_AO:
            A = "COM3: Analog Output Failure"
     Case COM3_DI:
            A = "COM3: Digital Input Failure"
     Case COM3_DO:
            A = "COM3: Digital Output Failure"
     Case COM3_RD:
            A = "COM3: Read Data Failure"
     Case COM3_RE:
            A = "COM3: Read Events Failure"
    End Select

    ' Display error message
    If A <> EmptyString Then
      MsgBox Rx, 48, A
    End If
End Sub

Sub ModError4(ErrValue As Integer, Rx As String)
Dim A As String
    ' Initialize
    A = EmptyString

    ' Determine error
    Select Case ErrValue
     Case COM4_AO:
            A = "COM4: Analog Output Failure"
     Case COM4_DI:
            A = "COM4: Digital Input Failure"
     Case COM4_DO:
            A = "COM4: Digital Output Failure"
     Case COM4_RD:
            A = "COM4: Read Data Failure"
     Case COM4_RE:
            A = "COM4: Read Events Failure"
    End Select

    ' Display error message
    If A <> EmptyString Then
      MsgBox Rx, 48, A
    End If
End Sub

Sub OpenPort(Index As Integer)
    ' Setup error handler and open the hardware port
    'On Error GoTo ComOpenError
    Settings.MousePointer = 11
    Select Case Index
     Case 1:
            ' Is port already Open
            If Commports(Index).PortIsOpen = 1 Then
              MainMenu!Comm1.PortOpen = False
            End If

            ' Setup values
            Screen2Port (1)
            SetPortValues (1)
            MainMenu!Comm1.InBufferSize = Commports(1).RXBufferLen
            MainMenu!Comm1.OutBufferSize = Commports(1).TXBufferLen
            MainMenu!Comm1.Settings = Commports(1).BaudRate + "," + Commports(1).Parity + "," + Commports(1).DataBits + "," + Commports(1).StopBits
            MainMenu!Comm1.CommPort = 1
            MainMenu!Comm1.PortOpen = True
            Settings!Check3D1.Value = True
            
     Case 2:
            ' Is port already Open
            If Commports(Index).PortIsOpen = 1 Then
              MainMenu!Comm2.PortOpen = False
            End If

            ' Setup values
            Screen2Port (2)
            SetPortValues (2)
            MainMenu!Comm2.InBufferSize = Commports(2).RXBufferLen
            MainMenu!Comm2.OutBufferSize = Commports(2).TXBufferLen
            MainMenu!Comm2.Settings = Commports(2).BaudRate + "," + Commports(2).Parity + "," + Commports(2).DataBits + "," + Commports(2).StopBits
            MainMenu!Comm2.CommPort = 2
            MainMenu!Comm2.PortOpen = True
            Settings!Check3D2.Value = True

     Case 3:
            ' Is port already Open
            If Commports(Index).PortIsOpen = 1 Then
              MainMenu!Comm3.PortOpen = False
            End If

            ' Setup values
            Screen2Port (3)
            SetPortValues (3)
            MainMenu!Comm3.InBufferSize = Commports(3).RXBufferLen
            MainMenu!Comm3.OutBufferSize = Commports(3).TXBufferLen
            MainMenu!Comm3.Settings = Commports(3).BaudRate + "," + Commports(3).Parity + "," + Commports(3).DataBits + "," + Commports(3).StopBits
            MainMenu!Comm3.CommPort = 3
            MainMenu!Comm3.PortOpen = True
            Settings!Check3D3.Value = True

     Case 4:
            ' Is port already Open
            If Commports(Index).PortIsOpen = 1 Then
              MainMenu!Comm4.PortOpen = False
            End If

            ' Setup values
            Screen2Port (4)
            SetPortValues (4)
            MainMenu!Comm4.InBufferSize = Commports(4).RXBufferLen
            MainMenu!Comm4.OutBufferSize = Commports(4).TXBufferLen
            MainMenu!Comm4.Settings = Commports(4).BaudRate + "," + Commports(4).Parity + "," + Commports(4).DataBits + "," + Commports(4).StopBits
            MainMenu!Comm4.CommPort = 4
            MainMenu!Comm4.PortOpen = True
            Settings!Check3D4.Value = True

    End Select
    Settings.MousePointer = 0
    Exit Sub

ComOpenError:
    ' Display proper error message
    Settings.MousePointer = 0
    PRG_Errors (68)

    ' Reset the port
    InitPort (Index)
    Exit Sub
End Sub

Sub PRG_Errors(Index As Integer)
Dim A As String * 55
    ' Initialize variables
    A = ""

    ' Determine error value
    Select Case Index
     Case Port_IsOpen:
            A = "Communications port is already open!"
     
     Case Port_NotOpen:
            A = "Selected communications port is not open!"

     Case Port_Timeout:
            A = "A communications timeout error has occurred"

     Case Port_Invalid:
            A = "Entered communications port number is invalid"

     Case Port_RequestOpen:
            A = "A communications port must be opened before proceeding"

     Case Invalid_BaudRate:
            A = "Invalid baud rate value in SetBaud()"

     Case Invalid_ModelNumber:
            A = "Please enter a valid model number"

     Case Hex2Long_StringToLong:
            A = "Long integer string value to long"

     Case Hex2Long_BadChar:
            A = "Invalid hexadecimal string character"

     Case 68:
            A = "Error Opening selected communications port!"

    End Select

    ' Display the error message and PAUSE
    If Index > 0 Then
      MsgBox A, 48, "Error Message"
    End If
End Sub

Function RD1(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RD command
    TX1 ("$" + Chr$(Address) + "RD" + Chr$(13))
    Rx = RX1()
    
    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError1 COM1_RD, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 9)
    End If

    ' Set return
    RD1 = Rx
End Function

Function RD2(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RD command
    TX2 ("$" + Chr$(Address) + "RD" + Chr$(13))
    Rx = RX2()
    
    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError2 COM2_RD, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 9)
    End If

    ' Set return
    RD2 = Rx
End Function

Function RD3(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RD command
    TX3 ("$" + Chr$(Address) + "RD" + Chr$(13))
    Rx = RX3()
    
    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError3 COM3_RD, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 9)
    End If

    ' Set return
    RD3 = Rx
End Function

Function RD4(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RD command
    TX4 ("$" + Chr$(Address) + "RD" + Chr$(13))
    Rx = RX4()
    
    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError4 COM4_RD, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 9)
    End If

    ' Set return
    RD4 = Rx
End Function

Function RE1(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RE command
    TX1 ("$" + Chr$(Address) + "RE" + Chr$(13))
    Rx = RX1()

    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError1 COM1_RE, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 7)
    End If

    ' Set return
    RE1 = Rx
End Function

Function RE2(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RE command
    TX2 ("$" + Chr$(Address) + "RE" + Chr$(13))
    Rx = RX2()

    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError2 COM2_RE, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 7)
    End If

    ' Set return
    RE2 = Rx
End Function

Function RE3(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RE command
    TX3 ("$" + Chr$(Address) + "RE" + Chr$(13))
    Rx = RX3()

    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError3 COM3_RE, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 7)
    End If

    ' Set Return
    RE3 = Rx
End Function

Function RE4(Address, ReportError As Integer) As String
Dim Rx As String
    ' Return numeric string value from RE command
    TX4 ("$" + Chr$(Address) + "RE" + Chr$(13))
    Rx = RX4()

    ' Validate response
    If Left$(Rx, 1) <> Asterisk Then
      ' Error occured
      If ReportError <> 0 Then
        ModError4 COM4_RE, Rx
      End If
    Else
      ' Parse data value - Remove preceeding ASTERISK
      Rx = Mid$(Rx, 2, 7)
    End If

    ' Set return
    RE4 = Rx
End Function

Function RX1() As String
Dim A, B As String
Dim Start As Integer
    '
    ' Read response message from port
    '
    ' Return value DOES NOT contain <CR> on end
    '
    A = ""
    Start = 0

    If Commports(1).PortIsOpen = 1 Then
      MainMenu!Comm1.InputLen = 1
      MainMenu!Timer1.Interval = Commports(1).RXTimeoutVal
      MainMenu!Timer1.Enabled = True

      Do
        Dummy = DoEvents()

        If MainMenu!Comm1.InBufferCount > 0 Then
          ' Read character
          B = Chr$(Asc(MainMenu!Comm1.Input) And &H7F)

          ' Check for valid start of message
          If (B = Asterisk) Or (B = QuestionMark) Then
            Start = 1
            A = B
           Else
            ' Build response message
            If Start = 1 Then A = A + B
          End If
        End If
      Loop Until (Right$(A, 1) = Chr$(13)) Or (Commports(1).TOExpired = 1)

      ' Disable COM1: timeout interval timer (0)
      MainMenu!Timer1.Interval = 0
      MainMenu!Timer1.Enabled = False

      ' Strip <CR> and Set return value
      If Commports(1).TOExpired = 1 Then
        Commports(1).TOExpired = 0
        RX1 = Timeout
      Else
        RX1 = Left$(A, Len(A) - 1)
      End If
    Else
     ' Port Not Open
     PRG_Errors (Port_NotOpen)
     RX1 = Timeout
    End If
End Function

Function RX2() As String
Dim A, B As String
Dim Start As Integer
    '
    ' Read response message from port
    '
    ' Return value DOES NOT contain <CR> on end
    '
    A = ""
    Start = 0

    If Commports(2).PortIsOpen = 1 Then
      MainMenu!Comm2.InputLen = 1
      MainMenu!Timer2.Interval = Commports(2).RXTimeoutVal
      MainMenu!Timer2.Enabled = True

      Do
        Dummy = DoEvents()

        If MainMenu!Comm2.InBufferCount > 0 Then
          ' Read character
          B = Chr$(Asc(MainMenu!Comm2.Input) And &H7F)

          ' Check for valid start of message
          If (B = Asterisk) Or (B = QuestionMark) Then
            Start = 1
            A = B
           Else
            ' Build response message
            If Start = 1 Then A = A + B
          End If
        End If
      Loop Until (Right$(A, 1) = Chr$(13)) Or (Commports(2).TOExpired = 1)

      ' Disable COM2: timeout interval timer (0)
      MainMenu!Timer2.Interval = 0
      MainMenu!Timer2.Enabled = False

      ' Strip <CR> and Set return value
      If Commports(2).TOExpired = 1 Then
        Commports(2).TOExpired = 0
        RX2 = Timeout
      Else
        RX2 = Left$(A, Len(A) - 1)
      End If
    Else
     ' Port Not Open
     PRG_Errors (Port_NotOpen)
     RX2 = Timeout
    End If
End Function

Function RX3() As String
Dim A, B As String
Dim Start As Integer
    '
    ' Read response message from port
    '
    ' Return value DOES NOT contain <CR> on end
    '
    A = ""
    Start = 0

    If Commports(3).PortIsOpen = 1 Then
      MainMenu!Comm3.InputLen = 1
      MainMenu!Timer3.Interval = Commports(3).RXTimeoutVal
      MainMenu!Timer3.Enabled = True

      Do
        Dummy = DoEvents()

        If MainMenu!Comm3.InBufferCount > 0 Then
          ' Read character
          B = Chr$(Asc(MainMenu!Comm3.Input) And &H7F)

          ' Check for valid start of message
          If (B = Asterisk) Or (B = QuestionMark) Then
            Start = 1
            A = B
           Else
            ' Build response message
            If Start = 1 Then A = A + B
          End If
        End If
      Loop Until (Right$(A, 1) = Chr$(13)) Or (Commports(3).TOExpired = 1)

      ' Disable COM3: timeout interval timer (0)
      MainMenu!Timer3.Interval = 0
      MainMenu!Timer3.Enabled = False

      ' Strip <CR> and Set return value
      If Commports(3).TOExpired = 1 Then
        Commports(3).TOExpired = 0
        RX3 = Timeout
      Else
        RX3 = Left$(A, Len(A) - 1)
      End If
    Else
     ' Port Not Open
     PRG_Errors (Port_NotOpen)
     RX3 = Timeout
    End If
End Function

Function RX4() As String
Dim A, B As String
Dim Start As Integer
    '
    ' Read response message from port
    '
    ' Return value DOES NOT contain <CR> on end
    '
    A = ""
    Start = 0

    If Commports(4).PortIsOpen = 1 Then
      MainMenu!Comm4.InputLen = 1
      MainMenu!Timer4.Interval = Commports(4).RXTimeoutVal
      MainMenu!Timer4.Enabled = True

      Do
        Dummy = DoEvents()

        If MainMenu!Comm4.InBufferCount > 0 Then
          ' Read character
          B = Chr$(Asc(MainMenu!Comm4.Input) And &H7F)

          ' Check for valid start of message
          If (B = Asterisk) Or (B = QuestionMark) Then
            Start = 1
            A = B
           Else
            ' Build response message
            If Start = 1 Then A = A + B
          End If
        End If
      Loop Until (Right$(A, 1) = Chr$(13)) Or (Commports(4).TOExpired = 1)

      ' Disable COM4: timeout interval timer (0)
      MainMenu!Timer4.Interval = 0
      MainMenu!Timer4.Enabled = False

      ' Strip <CR> and Set return value
      If Commports(4).TOExpired = 1 Then
        Commports(4).TOExpired = 0
        RX4 = Timeout
      Else
        RX4 = Left$(A, Len(A) - 1)
      End If
    Else
     ' Port Not Open
     PRG_Errors (Port_NotOpen)
     RX4 = Timeout
    End If
End Function

Sub Screen2Port(Index As Integer)
    ' Check for proper Baud Rate
    If Settings!Option3D6.Value = True Then
      Commports(Index).BaudRate = "300"
    End If

    If Settings!Option3D7.Value = True Then
      Commports(Index).BaudRate = "600"
    End If

    If Settings!Option3D8.Value = True Then
      Commports(Index).BaudRate = "1200"
    End If

    If Settings!Option3D9.Value = True Then
      Commports(Index).BaudRate = "2400"
    End If

    If Settings!Option3D10.Value = True Then
      Commports(Index).BaudRate = "4800"
    End If

    If Settings!Option3D11.Value = True Then
      Commports(Index).BaudRate = "9600"
    End If

    If Settings!Option3D12.Value = True Then
      Commports(Index).BaudRate = "19200"
    End If

    If Settings!Option3D13.Value = True Then
      Commports(Index).BaudRate = "38400"
    End If

    ' Check for proper Parity type
    If Settings!Option3D5.Value = True Then
      Commports(Index).Parity = "N"
    End If

    If Settings!Option3D2.Value = True Then
      Commports(Index).Parity = "O"
    End If

    If Settings!Option3D4.Value = True Then
      Commports(Index).Parity = "E"
    End If

    ' Check for proper Data bits
    If Settings!Option3D17.Value = True Then
      Commports(Index).DataBits = "7"
    End If

    If Settings!Option3D18.Value = True Then
      Commports(Index).DataBits = "8"
    End If
    
    ' Check for Proper Stop bits
    If Settings!Option3D14.Value = True Then
      Commports(Index).StopBits = "1"
    End If

    If Settings!Option3D15.Value = True Then
      Commports(Index).StopBits = "1.5"
    End If

    If Settings!Option3D16.Value = True Then
      Commports(Index).StopBits = "2"
    End If

    ' Initialize threshold values
    Commports(Index).RxThreshold = 0
    Commports(Index).TxThreshold = 0

    ' Check for proper FLOW CONTROL type
    If Settings!Option3D1.Value = True Then
      Commports(Index).FlowControl = 0
    Else
      Commports(Index).FlowControl = 2
    End If

    Commports(Index).ParityReplaceChar = ""
    Commports(Index).CTSTimeout = Val(Settings.Text3)
    Commports(Index).DSRTimeout = Val(Settings.Text4)
    Commports(Index).DTREnable = True
    Commports(Index).NullDiscardValue = True
    Commports(Index).RXBufferLen = Val(Settings.Text2)
    Commports(Index).TXBufferLen = Val(Settings.Text1)
    Commports(Index).RXTimeoutVal = Val(Settings.Text5)
    Commports(Index).TxTimeoutVal = Val(Settings.Text6)
    Commports(Index).TOExpired = 0
    Commports(Index).PortIsOpen = 1
End Sub

Sub ScreenBaud(S As String)
    Select Case S
     Case "300":
                Settings!Option3D6.Value = True
     Case "600":
                Settings!Option3D7.Value = True
     Case "1200":
                Settings!Option3D8.Value = True
     Case "2400":
                Settings!Option3D9.Value = True
     Case "4800":
                Settings!Option3D10.Value = True
     Case "9600":
                Settings!Option3D11.Value = True
     Case "19200":
                Settings!Option3D12.Value = True
     Case "38400":
                Settings!Option3D13.Value = True
    Case Else
      PRG_Errors (Invalid_BaudRate)
    End Select
End Sub

Sub ScreenDataBits(S As String)
    Select Case S
     Case "7":
                Settings!Option3D17.Value = True
     Case "8":
                Settings!Option3D18.Value = True
    End Select
End Sub

Sub ScreenFlow(I As Integer)
    Select Case I
     Case 0:
                Settings!Option3D1.Value = True
     Case 2:
                Settings!Option3D3.Value = True
    End Select
End Sub

Sub ScreenParity(S As String)
    Select Case S
     Case "N":
                Settings!Option3D5.Value = True
     Case "O":
                Settings!Option3D2.Value = True
     Case "E":
                Settings!Option3D4.Value = True
    End Select
End Sub

Sub ScreenStopBits(S As String)
    Select Case S
     Case "1":
                Settings!Option3D14.Value = True
     Case "1.5":
                Settings!Option3D15.Value = True
     Case "2":
                Settings!Option3D16.Value = True
    End Select
End Sub

Sub SetPortValues(Index As Integer)
    Select Case Index
     Case 1:
            MainMenu!Comm1.RThreshold = Commports(Index).RxThreshold
            MainMenu!Comm1.SThreshold = Commports(Index).TxThreshold
            MainMenu!Comm1.Handshaking = Commports(Index).FlowControl
            MainMenu!Comm1.ParityReplace = Commports(Index).ParityReplaceChar
            MainMenu!Comm1.CTSTimeout = Commports(Index).CTSTimeout
            MainMenu!Comm1.DSRTimeout = Commports(Index).DSRTimeout
            MainMenu!Comm1.DTREnable = Commports(Index).DTREnable
            MainMenu!Comm1.NullDiscard = Commports(Index).NullDiscardValue
            MainMenu!Comm1.InBufferSize = Commports(Index).RXBufferLen
            MainMenu!Comm1.OutBufferSize = Commports(Index).TXBufferLen

     Case 2:
            MainMenu!Comm2.RThreshold = Commports(Index).RxThreshold
            MainMenu!Comm2.SThreshold = Commports(Index).TxThreshold
            MainMenu!Comm2.Handshaking = Commports(Index).FlowControl
            MainMenu!Comm2.ParityReplace = Commports(Index).ParityReplaceChar
            MainMenu!Comm2.CTSTimeout = Commports(Index).CTSTimeout
            MainMenu!Comm2.DSRTimeout = Commports(Index).DSRTimeout
            MainMenu!Comm2.DTREnable = Commports(Index).DTREnable
            MainMenu!Comm2.NullDiscard = Commports(Index).NullDiscardValue
            MainMenu!Comm2.InBufferSize = Commports(Index).RXBufferLen
            MainMenu!Comm2.OutBufferSize = Commports(Index).TXBufferLen

     Case 3:
            MainMenu!Comm3.RThreshold = Commports(Index).RxThreshold
            MainMenu!Comm3.SThreshold = Commports(Index).TxThreshold
            MainMenu!Comm3.Handshaking = Commports(Index).FlowControl
            MainMenu!Comm3.ParityReplace = Commports(Index).ParityReplaceChar
            MainMenu!Comm3.CTSTimeout = Commports(Index).CTSTimeout
            MainMenu!Comm3.DSRTimeout = Commports(Index).DSRTimeout
            MainMenu!Comm3.DTREnable = Commports(Index).DTREnable
            MainMenu!Comm3.NullDiscard = Commports(Index).NullDiscardValue
            MainMenu!Comm3.InBufferSize = Commports(Index).RXBufferLen
            MainMenu!Comm3.OutBufferSize = Commports(Index).TXBufferLen

     Case 4:
            MainMenu!Comm4.RThreshold = Commports(Index).RxThreshold
            MainMenu!Comm4.SThreshold = Commports(Index).TxThreshold
            MainMenu!Comm4.Handshaking = Commports(Index).FlowControl
            MainMenu!Comm4.ParityReplace = Commports(Index).ParityReplaceChar
            MainMenu!Comm4.CTSTimeout = Commports(Index).CTSTimeout
            MainMenu!Comm4.DSRTimeout = Commports(Index).DSRTimeout
            MainMenu!Comm4.DTREnable = Commports(Index).DTREnable
            MainMenu!Comm4.NullDiscard = Commports(Index).NullDiscardValue
            MainMenu!Comm4.InBufferSize = Commports(Index).RXBufferLen
            MainMenu!Comm4.OutBufferSize = Commports(Index).TXBufferLen
    End Select
End Sub

Sub TX1(S As String)
    ' Check for OPEN COM1: port
    If Commports(1).PortIsOpen = 1 Then
      ' Delay thru TX delay value
      If Commports(1).TxTimeoutVal > 0 Then
        MainMenu!Comm1.RTSEnable = True
        MainMenu!Timer1.Interval = Commports(1).TxTimeoutVal
        MainMenu!Timer1.Enabled = True

        ' Wait for timeout
        Do
         Dummy = DoEvents()
        Loop Until Commports(1).TOExpired = 1
        
        ' Disable COM1: timeout interval timer (0)
        Commports(1).TOExpired = 0
        MainMenu!Timer1.Interval = 0
        MainMenu!Timer1.Enabled = False
      End If

      ' Transmit command
      MainMenu!Comm1.Output = S
    Else
      ' Port not OPEN
      PRG_Errors (Port_NotOpen)
    End If
End Sub

Sub TX2(S As String)
    ' Check for OPEN COM2: port
    If Commports(2).PortIsOpen = 1 Then
      ' Delay thru TX delay value
      If Commports(2).TxTimeoutVal > 0 Then
        MainMenu!Comm2.RTSEnable = True
        MainMenu!Timer2.Interval = Commports(2).TxTimeoutVal
        MainMenu!Timer2.Enabled = True

        ' Wait for timeout
        Do
         Dummy = DoEvents()
        Loop Until Commports(2).TOExpired = 1
        
        ' Disable COM2: timeout interval timer (0)
        Commports(2).TOExpired = 0
        MainMenu!Timer2.Interval = 0
        MainMenu!Timer2.Enabled = False
      End If

      ' Transmit command
      MainMenu!Comm2.Output = S
    Else
      ' Port not OPEN
      PRG_Errors (Port_NotOpen)
    End If
End Sub

Sub TX3(S As String)
    ' Check for OPEN COM3: port
    If Commports(3).PortIsOpen = 1 Then
      ' Delay thru TX delay value
      If Commports(3).TxTimeoutVal > 0 Then
        MainMenu!Comm3.RTSEnable = True
        MainMenu!Timer3.Interval = Commports(3).TxTimeoutVal
        MainMenu!Timer3.Enabled = True

        ' Wait for timeout
        Do
         Dummy = DoEvents()
        Loop Until Commports(3).TOExpired = 1
        
        ' Disable COM3: timeout interval timer (0)
        Commports(3).TOExpired = 0
        MainMenu!Timer3.Interval = 0
        MainMenu!Timer3.Enabled = False
      End If

      ' Transmit command
      MainMenu!Comm3.Output = S
    Else
      ' Port not OPEN
      PRG_Errors (Port_NotOpen)
    End If
End Sub

Sub TX4(S As String)
    ' Check for OPEN COM4: port
    If Commports(4).PortIsOpen = 1 Then
      ' Delay thru TX delay value
      If Commports(4).TxTimeoutVal > 0 Then
        MainMenu!Comm4.RTSEnable = True
        MainMenu!Timer4.Interval = Commports(4).TxTimeoutVal
        MainMenu!Timer4.Enabled = True

        ' Wait for timeout
        Do
         Dummy = DoEvents()
        Loop Until Commports(4).TOExpired = 1
        
        ' Disable COM4: timeout interval timer (0)
        Commports(4).TOExpired = 0
        MainMenu!Timer4.Interval = 0
        MainMenu!Timer4.Enabled = False
      End If

      ' Transmit command
      MainMenu!Comm4.Output = S
    Else
      ' Port not OPEN
      PRG_Errors (Port_NotOpen)
    End If
End Sub

Sub Values2Screen(Index As Integer)
    ' Set the screen Baud Rate
    ScreenBaud (Commports(Index).BaudRate)

    ' Set the screen Parity Type
    ScreenParity (Commports(Index).Parity)

    ' Set the screen Stop bits
    ScreenStopBits (Commports(Index).StopBits)

    ' Set the screen Data bits
    ScreenDataBits (Commports(Index).DataBits)

    ' Set the screen Flow control
    ScreenFlow (Commports(Index).FlowControl)

    ' Tx, Rx Buffer sizes
    Settings!Text1.Text = Str(Commports(Index).TXBufferLen)
    Settings!Text2.Text = Str(Commports(Index).RXBufferLen)

    ' CTS and DSR Timeout values
    Settings!Text3.Text = Str(Commports(Index).CTSTimeout)
    Settings!Text4.Text = Str(Commports(Index).DSRTimeout)

    ' Tx and Rx delay/timeout values
    Settings!Text5.Text = Str(Commports(Index).RXTimeoutVal)
    Settings!Text6.Text = Str(Commports(Index).TxTimeoutVal)
End Sub

