VERSION 2.00
Begin Form AODemo 
   BackColor       =   &H00C0C000&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Any analog output module"
   ClientHeight    =   4785
   ClientLeft      =   1425
   ClientTop       =   960
   ClientWidth     =   4575
   ClipControls    =   0   'False
   Height          =   5190
   Left            =   1365
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4785
   ScaleWidth      =   4575
   Top             =   615
   Width           =   4695
   Begin ComboBox Combo1 
      Height          =   315
      Left            =   2040
      Style           =   2  'Dropdown List
      TabIndex        =   14
      Top             =   2355
      Width           =   1455
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "DIGITAL INPUTS (Status)"
      Enabled         =   0   'False
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   1020
      Left            =   840
      TabIndex        =   9
      Top             =   2880
      Width           =   3015
      Begin Image Image6 
         Height          =   480
         Left            =   240
         Picture         =   COMMAO.FRX:0000
         Top             =   240
         Width           =   480
      End
      Begin Image Image5 
         Height          =   480
         Left            =   240
         Picture         =   COMMAO.FRX:027A
         Top             =   240
         Width           =   480
      End
      Begin Image Image4 
         Height          =   480
         Left            =   1320
         Picture         =   COMMAO.FRX:04F4
         Top             =   240
         Width           =   480
      End
      Begin Image Image3 
         Height          =   480
         Left            =   1320
         Picture         =   COMMAO.FRX:076E
         Top             =   240
         Width           =   480
      End
      Begin Image Image2 
         Height          =   480
         Left            =   2280
         Picture         =   COMMAO.FRX:09E8
         Top             =   240
         Width           =   480
      End
      Begin Image Image1 
         Height          =   480
         Left            =   2280
         Picture         =   COMMAO.FRX:0C62
         Top             =   240
         Width           =   480
      End
      Begin Label Label3 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "DI2"
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00000000&
         Height          =   240
         Left            =   300
         TabIndex        =   12
         Top             =   720
         Width           =   360
      End
      Begin Label Label2 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "DI1"
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00000000&
         Height          =   240
         Left            =   1320
         TabIndex        =   11
         Top             =   720
         Width           =   360
      End
      Begin Label Label1 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "DI0"
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00000000&
         Height          =   240
         Left            =   2400
         TabIndex        =   10
         Top             =   720
         Width           =   360
      End
   End
   Begin HScrollBar HScroll1 
      Height          =   372
      LargeChange     =   1000
      Left            =   1080
      Max             =   10000
      SmallChange     =   100
      TabIndex        =   5
      Top             =   1440
      Width           =   2532
   End
   Begin TextBox Text1 
      BackColor       =   &H00000000&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   19.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H0000FFFF&
      Height          =   615
      Left            =   1080
      MaxLength       =   9
      TabIndex        =   4
      Text            =   "+00000.00"
      Top             =   600
      Width           =   2535
   End
   Begin CommandButton AOCancel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Cancel"
      Height          =   372
      Left            =   3480
      TabIndex        =   3
      Top             =   4200
      Width           =   852
   End
   Begin CommandButton AOSetup 
      BackColor       =   &H00C0C0C0&
      Caption         =   "S&etup"
      Height          =   372
      Left            =   2400
      TabIndex        =   2
      Top             =   4200
      Width           =   852
   End
   Begin CommandButton AOStop 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Stop"
      Height          =   372
      Left            =   1320
      TabIndex        =   1
      Top             =   4200
      Width           =   852
   End
   Begin CommandButton AORun 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Run"
      Height          =   372
      Left            =   240
      TabIndex        =   0
      Top             =   4200
      Width           =   852
   End
   Begin Label Label4 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "PORT"
      Height          =   195
      Left            =   1320
      TabIndex        =   13
      Top             =   2400
      Width           =   525
   End
   Begin Label lblMaximum 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "100"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   240
      Left            =   3240
      TabIndex        =   8
      Top             =   1920
      Width           =   375
   End
   Begin Label lblMinimum 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "0"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   240
      Left            =   1080
      TabIndex        =   7
      Top             =   1920
      Width           =   105
   End
   Begin Label lblAOData 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "ANALOG OUTPUT"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   240
      Left            =   1080
      TabIndex        =   6
      Top             =   300
      Width           =   1935
   End
End
Option Explicit
' "Copyright (c) 1994,97 Dutile, Glines and Higgins Corporation"

Const FRMCaption = "Analog Output Demonstration"

' Local form variables
Dim Activate%

Sub AOCancel_Click ()
    ' Hide the analog output demonstration form
    Aodemo.Hide
End Sub

Sub AORun_Click ()
    ' Check for valid port
    If Val(Mid$(combo1.Text, 4, 1)) = 0 Then
      ' Error message - Invalid port selected
      MsgBox "Select valid port value [1..4]", 48
      
      ' Exit sub
      Exit Sub
    End If

    ' Disable other keys during scan
    AORun.Enabled = False
    AOSetup.Enabled = False
    AOCancel.Enabled = False
    AOStop.Enabled = True
    AOStop.Default = True
    combo1.Enabled = False
    frame1.Enabled = True

    ' Begin data logging
    Do Until (StopScan = 1)
     ' Output commands to selected port
     Select Case Val(Mid$(combo1.Text, 4, 1))
      Case 1: ' SERIAL COMMUNICATIONS PORT COM1:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO1 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI1(Address, 2, DisplayErrors))

      Case 2: ' SERIAL COMMUNICATIONS PORT COM2:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO2 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI2(Address, 2, DisplayErrors))

      Case 3: ' SERIAL COMMUNICATIONS PORT COM3:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO3 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI3(Address, 2, DisplayErrors))

      Case 4: ' SERIAL COMMUNICATIONS PORT COM4:
            ' Update analog output value
            If AOUpdate = 1 Then
              AO4 Address, DisplayErrors, (HScroll1.Value / 100)
              AOUpdate = 0
            End If

            ' Update digital inputs
            UpdateLEDs (DI4(Address, 2, DisplayErrors))
      Case Else
       ' Invalid port selected
       MsgBox "Select valid port value [1..4]", 48
     End Select

     ' Allow more events
     Dummy = DoEvents()
    Loop

    ' Disable scanning
    StopScan = 0
End Sub

Sub AOSetup_Click ()
    ' Show setup form
    PRGSetup.Show
End Sub

Sub AOStop_Click ()
    ' Enable other keys after scan
    AORun.Enabled = True
    AORun.Default = True
    AOSetup.Enabled = True
    AOCancel.Enabled = True
    AOStop.Enabled = False
    combo1.Enabled = True
    frame1.Enabled = False

    ' Set flag to stop scanning
    StopScan = 1
End Sub

Sub Combo1_Click ()
    ' Check for setup
    If Activate% = 0 Then
      ' User pressed mouse button
      If combo1.Text = SetupCaption Then
        ' Display port settings form
        PRGSetup.Show
      End If
    Else
      ' Form Activation brought us here
      Activate% = 0
    End If
End Sub

Sub Form_Activate ()
    ' Set activation flag
    Activate% = 1

    ' Update ports box
    LoadPorts combo1
End Sub

Sub Form_Load ()
    ' Initialize horizontal scroll bar and text box
    HScroll1.Value = HScroll1.Min
    text1.Text = Format$((HScroll1.Value / 100), DataFormat)

    ' Initialize digital input LED's
    UpdateLEDs (&HFF)

    ' Initialize caption
    Aodemo.Caption = FRMCaption

    ' Set form activation flag
    Activate% = 1
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
    ' Prompt if still scanning
    If AOStop.Enabled = True Then
      ' Display message
      MsgBox "Must stop demo first", 48

      ' Cancel the unload function
      Cancel = 1
    End If
End Sub

Sub HScroll1_Change ()
    ' Set Analog Output flag
    text1.Text = Format$((HScroll1.Value / 100), DataFormat)
    AOUpdate = 1
End Sub

Sub Text1_Change ()
Dim Old As Long
    ' Update horizontal scroll bar
    On Error GoTo BadValue
    Old = HScroll1.Value
    HScroll1.Value = Val(text1.Text) * 100
    AOUpdate = 1
    Exit Sub

BadValue:
    On Error GoTo 0
    HScroll1.Value = Old
    text1.Text = HScroll1.Value / 100
    AOUpdate = 0
    Exit Sub
End Sub

Sub UpdateLEDs (Status As Long)
    ' Update the digital input LED's
    ' Check Bit #0
    If (Status And B0) = LOW Then
      Image1.Enabled = True
      Image1.Visible = True
      Image2.Enabled = False
      Image2.Visible = False
    Else
      Image1.Enabled = False
      Image1.Visible = False
      Image2.Enabled = True
      Image2.Visible = True
    End If

    ' Check Bit #1
    If (Status And B1) = LOW Then
      Image3.Enabled = True
      Image3.Visible = True
      Image4.Enabled = False
      Image4.Visible = False
    Else
      Image3.Enabled = False
      Image3.Visible = False
      Image4.Enabled = True
      Image4.Visible = True
    End If

    ' Check Bit #2
    If (Status And B2) = LOW Then
      Image5.Enabled = True
      Image5.Visible = True
      Image6.Enabled = False
      Image6.Visible = False
    Else
      Image5.Enabled = False
      Image5.Visible = False
      Image6.Enabled = True
      Image6.Visible = True
    End If
End Sub

